<?php

namespace Drupal\paragraphs_blokkli_scheduler\Plugin\GraphQL\SchemaExtension;

use Drupal\graphql\GraphQL\ResolverBuilder;
use Drupal\graphql\GraphQL\ResolverRegistryInterface;
use Drupal\graphql\Plugin\GraphQL\SchemaExtension\SdlSchemaExtensionPluginBase;
use Drupal\paragraphs\ParagraphInterface;

/**
 * A schema extension to add support for the paragraphs_blokkli_scheduler module.
 *
 * @SchemaExtension(
 *   id = "paragraphs_blokkli_scheduler",
 *   name = "Paragraphs Blokkli Scheduler",
 *   description = "Add support for scheduler module.",
 *   schema = "core_composable"
 * )
 */
class SchedulerExtension extends SdlSchemaExtensionPluginBase {

  /**
   * {@inheritdoc}
   */
  public function registerResolvers(ResolverRegistryInterface $registry): void {
    $builder = new ResolverBuilder();

    $registry->addFieldResolver(
      'Paragraph',
      'isScheduled',
      $builder->callback(function (ParagraphInterface $paragraph) {

        if ($paragraph->hasField('publish_on') && $paragraph->hasField('unpublish_on')) {
          $is_publish_enabled = !$paragraph->get('publish_on')->isEmpty();
          $is_unpublish_enabled = !$paragraph->get('unpublish_on')->isEmpty();
          return ($is_publish_enabled || $is_unpublish_enabled);
        }
        return FALSE;
      })
    );
  }

}
